#!/bin/bash

# extract archive
unzip -o *.zip

# Process each client configuration file
for client_file in *.ovpn; do
    # Extract the client name (e.g., 1client1, 2.client2)
    client_name=$(basename "$client_file" .ovpn)
    
    # Import the client configuration
    nmcli connection import type openvpn file "$client_file"
    
    # Rename the connection to include the client name
    nmcli connection modify "$client_name" connection.id "1cc-ovpn-$client_name"
    
    # Get the VPN data from nmcli
    vpnd=$(nmcli connection show "1cc-ovpn-$client_name" | grep "vpn.data" | sed 's/.*vpn.data://' | sed -e 's/^ *//')
    
    # Delete some variables in vpn.data string
    vpnd=$(echo $vpnd | sed 's/.username[^,]*,//' | sed 's/.password-flags[^,]*,//' | sed 's/.connection-type[^,]*,//')
    
    # Add deleted variables with new values
    vpnd=$(echo $vpnd, username = "$client_name", password-flags = 2, connection-type = password-tls)
    
    # Import new vpn.data into nmcli
    nmcli connection modify "1cc-ovpn-$client_name" vpn.data "$vpnd"
    nmcli connection modify "1cc-ovpn-$client_name" ipv4.never-default yes
done

# Configure linphone (if needed)
chmod +x *linphone*.sh
./*linphone*.sh

