#!/bin/bash

# extract archive
unzip -o *.zip

# determinate key number
key=$(ls -1 | grep -v .sh | grep client)
num=$(echo $key | sed -e 's/[^0-9]//g')

# import configs
uname=$(whoami)
if grep -q "thomas" /etc/passwd; then
    su -c "nmcli connection import type openvpn file client$num/client$num.ovpn
    nmcli connection import type openvpn file client$num/bak-client$num.ovpn
    sudo -S nmcli connection modify "client$num" connection.permissions user:$uname
    sudo -S nmcli connection modify "bak-client$num" connection.permissions user:$uname" thomas
else
    nmcli connection import type openvpn file client$num/client$num.ovpn
    nmcli connection import type openvpn file client$num/bak-client$num.ovpn
fi
nmcli connection modify "client$num" connection.id "1cc-vpn-client$num"
nmcli connection modify "bak-client$num" connection.id "1cc-backup-vpn-client$num"

function vpnmod() {
# get vpn.data from nmcli
vpnd=$(nmcli connection show "$1" | grep "vpn.data" | sed 's/.*vpn.data://' | sed -e 's/^ *//')

# delete some variables in vpn.data string
vpnd=$(echo $vpnd | sed 's/.username[^,]*,//' | sed 's/.password-flags[^,]*,//' | sed 's/.connection-type[^,]*,//')

# add deleted variables with new values
vpnd=$(echo $vpnd, username = client$num, password-flags = 2, connection-type = password-tls)
}

# import new vpn.data into nmcli
vpnmod "1cc-vpn-client$num"
nmcli connection modify "1cc-vpn-client$num" vpn.data "$vpnd"
nmcli connection modify "1cc-vpn-client$num" ipv4.never-default yes
vpnmod "1cc-backup-vpn-client$num"
nmcli connection modify "1cc-backup-vpn-client$num" vpn.data "$vpnd"
nmcli connection modify "1cc-backup-vpn-client$num" ipv4.never-default yes

# configure linphone
chmod +x *linphone*.sh
./*linphone*.sh
